-- Fleming


set sql_safe_updates=0;


-- TIME_TABLE_UPDATE_FOR_HOD_RCPNT        
SET @timeTableUpdateForHOD=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_HOD_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.courseCoveragePlanId AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
	sa.salutationName AS SALUTATION_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    ps.firstName AS HOD_FIRST_NAME,
    ps.lastName AS HOD_LAST_NAME,
    sal.salutationName AS HOD_SALUTATION_NAME,
	ps.emailId AS EMAIL_ID,
    ps.mobileNumber AS MOBILE_NO,
    ps.mobileCountryCode AS MOBILE_CODE,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
        LEFT JOIN
    staffs s ON s.userId = T1.facultyId
        LEFT JOIN
    persons p ON p.id = s.personId
	LEFT JOIN
    salutations sa ON sa.id = p.salutationId
        LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
        LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId    
    	LEFT JOIN
    department d ON  oldc.departmentId = d.id
    	LEFT JOIN
    staffs st ON  d.hodid = st.userId 
		LEFT JOIN
    persons ps ON st.personId = ps.id 
		LEFT JOIN
    salutations sal ON sal.id = ps.salutationId
    	LEFT JOIN
        multi_language ml on ps.correspondence_language=ml.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = st.userId
	where
    T1.courseCoveragePlanId IN (namedParams)
GROUP BY T1.courseCoveragePlanId" WHERE `dataProviderId`=@timeTableUpdateForHOD;


-- TIME_TABLE_DELETE_FOR_FACULTY_RCPNT        
SET @timeTableDeleteForFaculty=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.courseCoveragePlanId AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
	p.emailId AS EMAIL_ID,
    oldp.alternateEmailId AS ALTERNATE_EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
	sal.salutationName AS SALUTATION_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
        LEFT JOIN
    staffs s ON s.userId = T1.facultyId
        LEFT JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
        LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
        LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
        multi_language ml on p.correspondence_language=ml.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
WHERE
    T1.courseCoveragePlanId IN (namedParams)
GROUP BY T1.courseCoveragePlanId" WHERE `dataProviderId`=@timeTableDeleteForFaculty;



-- TIME_TABLE_UPDATE_FOR_FACULTY_RCPNT        
SET @timeTableUpdateForFaculty=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_FACULTY_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FIRST_NAME,
    p.lastName AS LAST_NAME,
	p.emailId AS EMAIL_ID,
    oldp.alternateEmailId AS ALTERNATE_EMAIL_ID,
    p.mobileNumber AS MOBILE_NO,
    p.mobileCountryCode AS MOBILE_CODE,
	sal.salutationName AS SALUTATION_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    ml.code as LANGUGE_KEY,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
        LEFT JOIN
    staffs s ON s.userId = T1.facultyId
        LEFT JOIN
    persons p ON p.id = s.personId
        LEFT JOIN
    salutations sal ON sal.id = p.salutationId
        LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
        LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
        multi_language ml on p.correspondence_language=ml.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = s.userId
WHERE
    T1.id IN (namedParams)
GROUP BY T1.courseCoveragePlanId
" WHERE `dataProviderId`=@timeTableUpdateForFaculty;


-- TIME_TABLE_DELETE_FOR_MOTHER_RCPNT        
SET @timeTableDeleteForMother=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id		
    LEFT JOIN
    multi_language ml on T5.correspondence_language =ml.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'MOTHER'
" WHERE `dataProviderId`=@timeTableDeleteForMother;


-- TIME_TABLE_DELETE_FOR_FATHER_RCPNT        
SET @timeTableDeleteForFather=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON,
    ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
      LEFT  JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
		LEFT JOIN
     multi_language ml on   T5.correspondence_language=ml.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'FATHER'
" WHERE `dataProviderId`=@timeTableDeleteForFather;


-- TIME_TABLE_DELETE_FOR_STUDENT_RCPNT        
SET @timeTableDeleteForStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_DELETE_FOR_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
   -- T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
	sal.salutationName AS SALUTATION_NAME,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
	T1.reasonForSubstituteSession AS SUBSTITUTE_REASON,
	ml.code as LANGUAGE_KEY
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    salutations sal ON sal.id = T5.salutationId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
       LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
	LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
    LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id

WHERE
    T1.id IN (namedParams) group by T3.id" WHERE `dataProviderId`=@timeTableDeleteForStudent;



-- TIME_TABLE_UPDATE_FOR_MOTHER_RCPNT        
SET @timeTableUpdateForMother=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
    LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'MOTHER'
" WHERE `dataProviderId`=@timeTableUpdateForMother;


-- TIME_TABLE_UPDATE_FOR_FATHER_RCPNT        
SET @timeTableUpdateForFather=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_FATHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T7.firstName AS FIRST_NAME,
    T7.lastName AS LAST_NAME,
    T7.printName AS PRINT_NAME,
    T7.emailId AS EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
    sal.salutationName AS SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	(select group_concat(distinct deviceTokenId) from fire_base_persons_info f where ps.userId = f.userId)  AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
      LEFT  JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
       LEFT JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    person_relationships AS pr ON pr.personId = T5.id
        INNER JOIN
    persons AS T7 ON T7.id = pr.relatedPersonId
  		LEFT JOIN
    salutations sal ON sal.id = T7.salutationId
		LEFT JOIN
	parents ps on ps.personId = T7.id
    LEFT JOIN
    multi_language ml on T5.correspondence_language = ml.id
WHERE
    T1.id IN (namedParams) AND pr.relationship = 'FATHER'
" WHERE `dataProviderId`=@timeTableUpdateForFather;



-- TIME_TABLE_UPDATE_FOR_STUDENT_RCPNT        
SET @timeTableUpdateForStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='TIME_TABLE_UPDATE_FOR_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    DATE_FORMAT(T1.sessionDate, '%d-%m-%Y') AS SESSION_DATE,
    DATE_FORMAT(T1.slotFrom, '%h:%i %p') AS SLOT_FROM,
    DATE_FORMAT(T1.slotTo, '%h:%i %p') AS SLOT_TO,
    p.firstName AS FACULTY_FIRST_NAME,
    p.lastName AS FACULTY_LAST_NAME,
    c.courseCodeToBePrinted AS COURSE_CODE,
    c.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    r1.resourceName AS ROOM_NAME,
    oldp.firstName AS OLD_FACULTY_FIRST_NAME,
    oldp.lastName AS OLD_FACULTY_LAST_NAME,
    oldc.courseCodeToBePrinted AS OLD_COURSE_CODE,
    oldc.nameToBePrinted AS OLD_COURSE_NAME_TO_BE_PRINTED,
    oldr.resourceName AS OLD_ROOM_NAME,
    DATE_FORMAT(T1.oldSessionDate, '%d-%m-%Y') AS OLD_SESSION_DATE,
    DATE_FORMAT(T1.oldSlotFrom, '%h:%i %p') AS OLD_SLOT_FROM,
    DATE_FORMAT(T1.oldSlotTo, '%h:%i %p') AS OLD_SLOT_TO,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
   -- T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.academyName AS ACADEMY_NAME,
    T6.locationName AS LOCATION_NAME,
    T6.displayName AS ACADEMY_NAME_LOCATION,
	sal.salutationName AS SALUTATION_NAME,
    ml.code as LANGUAGE_KEY,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    course_coverage_plan_msg T1
        LEFT JOIN
    students T2 ON T2.userId = T1.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    persons T5 ON T5.id = T2.personId
        LEFT JOIN
    salutations sal ON sal.id = T5.salutationId
        LEFT JOIN
    courses c ON c.id = T1.courseId
        LEFT JOIN
    courses oldc ON oldc.id = T1.oldCourseId
        LEFT JOIN
    resources r1 ON r1.id = T1.classRoomId
        LEFT JOIN
    resources oldr ON oldr.id = T1.oldClassRoomId
       LEFT JOIN
    staffs s ON s.userId = T1.facultyId
       LEFT JOIN
    persons p ON p.id = s.personId
      LEFT  JOIN
    staffs olds ON olds.userId = T1.oldFacultyByFacultyId
       LEFT JOIN
    persons oldp ON oldp.id = olds.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
		LEFT JOIN
        multi_language ml on T5.correspondence_language=ml.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
    T1.id IN (namedParams) group by T3.id" WHERE `dataProviderId`=@timeTableUpdateForStudent;


-- HOMEWORK_ASSIGNMENT_SUBMIT_RCPNT        
SET @homeworkAssignmentSubmit=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_SUBMIT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.firstName AS FIRST_NAME,
    T4.lastName AS LAST_NAME,
    T4.printName AS PRINT_NAME,
    T4.emailId AS EMAIL_ID,
    T4.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T4.mobileNumber AS MOBILE_NO,
    T4.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
	DATE_FORMAT(NOW(), '%d-%m-%Y %H:%i:%s') AS SUBMIT_TIMESTAMP,
    group_concat(distinct f.deviceTokenId) AS DEVICE_ID,
    ml.code as LANGUAGE_KEY
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
        multi_language ml on T4.correspondence_language = ml.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams) group by T1.id
" WHERE `dataProviderId`=@homeworkAssignmentSubmit;



-- HOMEWORK_ASSIGNMENT_SAVE_RCPNT        
SET @homeworkAssignmentSave=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOMEWORK_ASSIGNMENT_SAVE_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id AS ID,
    T4.firstName AS FIRST_NAME,
    T4.lastName AS LAST_NAME,
    T4.printName AS PRINT_NAME,
    T4.emailId AS EMAIL_ID,
    T4.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T4.mobileNumber AS MOBILE_NO,
    T4.mobileCountryCode AS MOBILE_CODE,
    T5.academyName AS ACADEMY_NAME,
    T5.locationName AS LOCATION_NAME,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    T6.assignmentName AS ASSIGNMENT_NAME,
    T8.nameToBePrinted AS COURSE_NAME_TO_BE_PRINTED,
    T8.courseCode AS COURSE_CODE,
    T7.courseVariantCode AS COURSE_VARIANT_CODE,
    T7.courseVariantDescription AS COURSE_VARIANT_DESCRIPTION,
	DATE_FORMAT(NOW(), '%d-%m-%Y %H:%i:%s') AS SUBMIT_TIMESTAMP,
    ml.code as LANGUAGE_KEY,
    group_concat(distinct f.deviceTokenId) AS DEVICE_ID
FROM
    group_hw_assignment T1
        LEFT JOIN
    admission AS T2 ON T2.id = T1.admissionId
        LEFT JOIN
    students AS T3 ON T3.userId = T2.studentId
        LEFT JOIN
    persons AS T4 ON T4.id = T3.personId
        LEFT JOIN
    academy_location T5 ON T5.id = T2.academyLocationId
        LEFT JOIN
    course_hw_asignment T6 ON T6.id = T1.hwAssignmentId
        LEFT JOIN
    course_variants T7 ON T7.id = T6.courseVariantId
        LEFT JOIN
    courses T8 ON T8.id = T7.courseId
        LEFT JOIN
        multi_language ml on T4.correspondence_language =ml.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T3.userId
WHERE
    T1.id IN (namedParams) group by T1.id
" WHERE `dataProviderId`=@homeworkAssignmentSave;



-- UPDATE_ATTENDANCE_SESSION_WISE_LOCAL_GUARDIAN_RCPNT        
SET @updateAttendanceSession=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_SESSION_WISE_LOCAL_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,  
    T10.sessionNo as SESSION_NUMBER,     
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN 
    multi_language ml on T5.correspondence_language =ml.id
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'LOCAL_GUARDIAN' AND T6.whetherDeleted = false
" WHERE `dataProviderId`=@updateAttendanceSession;


-- UPDATE_ATTENDANCE_SESSION_WISE_GUARDIAN_RCPNT        
SET @updateAttendanceSessionWiseGuardian=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_SESSION_WISE_GUARDIAN_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
    T10.sessionNo as SESSION_NUMBER,   
    (case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
    date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
    LEFT JOIN
    multi_language ml on T5.correspondence_language = ml.id
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'GUARDIAN' AND T6.whetherDeleted = false
" WHERE `dataProviderId`=@updateAttendanceSessionWiseGuardian;



-- UPDATE_ATTENDANCE_SESSION_WISE_MOTHER_RCPNT        
SET @updateAttendanceSessionWiseMother=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_SESSION_WISE_MOTHER_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T1.id as ID,
    T5.printName AS STUDENT_PRINT_NAME,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T7.emailId AS EMAIL_ID,
	T7.alternateEmailId as ALTERNATE_EMAIL_ID,
    T7.mobileNumber AS MOBILE_NO,
    T7.mobileCountryCode AS MOBILE_CODE,
    T2.itemValue as ATTENDANCE_MARKING_TYPE,
   -- T2.attendanceStatus AS ATTENDANCE_STATUS,
    T7.printName AS PRINT_NAME,
    T7.firstName AS FIRST_NAME,
    T7.middleName AS MIDDLE_NAME,
    T7.lastName AS LAST_NAME,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T9.salutationName AS SALUTATION_NAME,
    T12.printName AS FACULTY_PRINT_NAME,
    T12.firstName AS FACULTY_FIRST_NAME,
    T12.lastName AS FACULTY_LAST_NAME,
    T13.salutationName AS FACULTY_SALUTATION_NAME,
	DATE_FORMAT(T10.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,   
    T10.sessionNo as SESSION_NUMBER,    
(case when (T2.itemValue = T2.attendanceStatus) then CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2)))
     else CONCAT(T2.itemValue, '/', CONCAT(UCASE(LEFT(T2.attendanceStatus, 1)), LCASE(SUBSTRING(T2.attendanceStatus, 2))))
    end) as ATTENDANCE_STATUS,
date_format(DATE(NOW()), '%d-%m-%Y') as TODAY_DATE,
ml.code as LANGUAGE_KEY
FROM
    student_program_attendance_details as T1
     LEFT JOIN
    attendance_marking_type AS T2 ON T2.id = T1.attendanceMarkingTypeId
     LEFT JOIN
    admission AS T3 ON T3.id = T1.admissionId
	 LEFT JOIN
    students AS T4 ON T4.userId = T3.studentId
     LEFT JOIN
    persons AS T5 ON T5.id = T4.personId
	 LEFT JOIN
    person_relationships as T6 ON T6.personId = T5.id
	 LEFT JOIN
    persons AS T7 ON T7.id = T6.relatedPersonId
    LEFT JOIN
    academy_location T8 ON T8.id = T3.academyLocationId
    LEFT JOIN
    salutations AS T9 ON T9.id = T7.salutationId
    LEFT JOIN
    student_program_attendance AS T10 ON T10.id = T1.attendanceId
    LEFT JOIN 
    staffs AS T11 ON T11.userId = T1.lastUpdatedBy
    LEFT JOIN
    persons AS T12 ON T12.id = T11.PersonId
    LEFT JOIN
    salutations AS T13 ON T13.id = T12.salutationId
      LEFT JOIN
      multi_language ml on T5.correspondence_language=ml.id 
WHERE
T1.id IN (namedParams) AND T7.isMobUseForCommunication = TRUE  AND T6.relationship = 'MOTHER' AND T6.whetherDeleted = false
" WHERE `dataProviderId`=@updateAttendanceSessionWiseMother;


-- UPDATE_ATTENDANCE_SESSION_WISE_STUDENT_RCPNT        
SET @updateAttendanceSessionWiseStudent=(SELECT id FROM dtprovider WHERE `dataProviderName`='UPDATE_ATTENDANCE_SESSION_WISE_STUDENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS ID,
    T5.firstName AS FIRST_NAME,
    T5.lastName AS LAST_NAME,
    T5.printName AS PRINT_NAME,
    T5.emailId AS EMAIL_ID,
    T5.alternateEmailId AS ALTERNATE_EMAIL_ID,
    T5.mobileNumber AS MOBILE_NO,
    T5.mobileCountryCode AS MOBILE_CODE,
    T6.displayName AS ACADEMY_NAME,
    DATE_FORMAT(T1.dateOfAttendance, '%d-%m-%Y') AS SESSION_DATE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    T1.sessionNo AS SESSION_NUMBER,
    (CASE
        WHEN
            (T9.itemValue = T9.attendanceStatus)
        THEN
            CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                    LCASE(SUBSTRING(T9.attendanceStatus, 2)))
        ELSE CONCAT(T9.itemValue,
                '/',
                CONCAT(UCASE(LEFT(T9.attendanceStatus, 1)),
                        LCASE(SUBSTRING(T9.attendanceStatus, 2))))
    END) AS ATTENDANCE_STATUS,
    T8.printName AS FACULTY_PRINT_NAME,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE,
    ml.code as LANGUAGE_KEY
FROM
    student_program_attendance T1
        LEFT JOIN
    student_program_attendance_details T2 ON T2.attendanceId = T1.id
        LEFT JOIN
    admission T3 ON T3.id = T2.admissionId
        LEFT JOIN
    students T4 ON T4.userId = T3.studentId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    academy_location T6 ON T6.id = T1.academyLocationId
        LEFT JOIN
    staffs T7 ON T7.userId = T2.lastUpdatedBy
        LEFT JOIN
    persons T8 ON T8.id = T7.personId
        LEFT JOIN
    attendance_marking_type AS T9 ON T9.id = T2.attendanceMarkingTypeId
        LEFT JOIN
    multi_language ml on T5.correspondence_language=ml.id  
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
WHERE

    T2.id IN (namedParams) group by T2.id" WHERE `dataProviderId`=@updateAttendanceSessionWiseStudent;
    
set sql_safe_updates=1;


